/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.CursorableLinkedList;

class CursorableSubList
extends CursorableLinkedList
implements List {
    protected CursorableLinkedList _list = null;
    protected CursorableLinkedList.Listable _pre = null;
    protected CursorableLinkedList.Listable _post = null;

    public int hashCode() {
        this.checkForComod();
        return super.hashCode();
    }

    public int size() {
        this.checkForComod();
        return super.size();
    }

    protected void checkForComod() throws ConcurrentModificationException {
        if (this._modCount != this._list._modCount) {
            throw new ConcurrentModificationException();
        }
    }

    public void clear() {
        this.checkForComod();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        this.checkForComod();
        return super.isEmpty();
    }

    public Object getFirst() {
        this.checkForComod();
        return super.getFirst();
    }

    public Object getLast() {
        this.checkForComod();
        return super.getLast();
    }

    public Object removeFirst() {
        this.checkForComod();
        return super.removeFirst();
    }

    public Object removeLast() {
        this.checkForComod();
        return super.removeLast();
    }

    public Object[] toArray() {
        this.checkForComod();
        return super.toArray();
    }

    public Object get(int n) {
        this.checkForComod();
        return super.get(n);
    }

    public Object remove(int n) {
        this.checkForComod();
        return super.remove(n);
    }

    public void add(int n, Object object) {
        this.checkForComod();
        super.add(n, object);
    }

    public int indexOf(Object object) {
        this.checkForComod();
        return super.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        this.checkForComod();
        return super.lastIndexOf(object);
    }

    public boolean add(Object object) {
        this.checkForComod();
        return super.add(object);
    }

    public boolean addFirst(Object object) {
        this.checkForComod();
        return super.addFirst(object);
    }

    public boolean addLast(Object object) {
        this.checkForComod();
        return super.addLast(object);
    }

    public boolean contains(Object object) {
        this.checkForComod();
        return super.contains(object);
    }

    public boolean equals(Object object) {
        this.checkForComod();
        return super.equals(object);
    }

    public boolean remove(Object object) {
        this.checkForComod();
        return super.remove(object);
    }

    public boolean addAll(int n, Collection collection) {
        this.checkForComod();
        return super.addAll(n, collection);
    }

    public boolean addAll(Collection collection) {
        this.checkForComod();
        return super.addAll(collection);
    }

    public boolean containsAll(Collection collection) {
        this.checkForComod();
        return super.containsAll(collection);
    }

    public boolean removeAll(Collection collection) {
        this.checkForComod();
        return super.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        this.checkForComod();
        return super.retainAll(collection);
    }

    public Iterator iterator() {
        this.checkForComod();
        return super.iterator();
    }

    public List subList(int n, int n2) {
        this.checkForComod();
        return super.subList(n, n2);
    }

    public ListIterator listIterator() {
        this.checkForComod();
        return super.listIterator();
    }

    public ListIterator listIterator(int n) {
        this.checkForComod();
        return super.listIterator(n);
    }

    CursorableSubList(CursorableLinkedList cursorableLinkedList, int n, int n2) {
        if (0 > n || cursorableLinkedList.size() < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this._list = cursorableLinkedList;
        if (n < cursorableLinkedList.size()) {
            this._head.setNext(this._list.getListableAt(n));
            this._pre = null == this._head.next() ? null : this._head.next().prev();
        } else {
            this._pre = this._list.getListableAt(n - 1);
        }
        if (n == n2) {
            this._head.setNext(null);
            this._head.setPrev(null);
            this._post = n2 < cursorableLinkedList.size() ? this._list.getListableAt(n2) : null;
        } else {
            this._head.setPrev(this._list.getListableAt(n2 - 1));
            this._post = this._head.prev().next();
        }
        this._size = n2 - n;
        this._modCount = this._list._modCount;
    }

    protected void removeListable(CursorableLinkedList.Listable listable) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == listable && this._head.prev() == listable) {
            this._head.setNext(null);
            this._head.setPrev(null);
        }
        if (this._head.next() == listable) {
            this._head.setNext(listable.next());
        }
        if (this._head.prev() == listable) {
            this._head.setPrev(listable.prev());
        }
        this._list.removeListable(listable);
        this.broadcastListableRemoved(listable);
    }

    public Object set(int n, Object object) {
        this.checkForComod();
        return super.set(n, object);
    }

    public Object[] toArray(Object[] objectArray) {
        this.checkForComod();
        return super.toArray(objectArray);
    }

    protected CursorableLinkedList.Listable insertListable(CursorableLinkedList.Listable listable, CursorableLinkedList.Listable listable2, Object object) {
        ++this._modCount;
        ++this._size;
        CursorableLinkedList.Listable listable3 = this._list.insertListable(null == listable ? this._pre : listable, null == listable2 ? this._post : listable2, object);
        if (null == this._head.next()) {
            this._head.setNext(listable3);
            this._head.setPrev(listable3);
        }
        if (listable == this._head.prev()) {
            this._head.setPrev(listable3);
        }
        if (listable2 == this._head.next()) {
            this._head.setNext(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }
}

